/*
 * @(#)DataURIFrame.java  1.0  2012-03-05
 *
 * Copyright (c) 2012 Werner Randelshofer, Immensee, Switzerland.
 * All rights reserved.
 *
 * You may not use, copy or modify this file, except in compliance with the
 * license agreement you entered into with Werner Randelshofer.
 * For details see accompanying license terms.
 */
package ch.randelshofer.datauri;

/**
 * DataURIFrame.
 *
 * @author Werner Randelshofer
 * @version 1.0 2012-03-05 Created.
 */
public class DataURIFrame extends javax.swing.JFrame {
    String versionNumber="1.0";
    String versionDate="2012-03-06";

    /** Creates new form DataURLFrame */
    public DataURIFrame() {
        initComponents();
        setSize(400,400);
        setTitle(getTitle()+" "+versionNumber);
        textArea.setTransferHandler(new DataURITransferHandler());
        textArea.setText(textArea.getText()
                +"\n\nData URI Creator "+versionNumber+" "+versionDate
                +"\nCopyright (c) Werner Randelshofer, Immensee, Switzerland"
                );
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        textArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Data URI Creator");

        textArea.setColumns(20);
        textArea.setEditable(false);
        textArea.setRows(5);
        textArea.setText("Drop a file into this field to generate a data URI.");
        scrollPane.setViewportView(textArea);

        getContentPane().add(scrollPane, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            @Override
            public void run() {
                new DataURIFrame().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JTextArea textArea;
    // End of variables declaration//GEN-END:variables
}
